/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.BundleCloneCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BundleClone
extends Resource {
    private static final long serialVersionUID = 223439984305390L;
    private final String bundleSid;
    private final String accountSid;
    private final String regulationSid;
    private final String friendlyName;
    private final Status status;
    private final ZonedDateTime validUntil;
    private final String email;
    private final URI statusCallback;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static BundleCloneCreator creator(String pathBundleSid, String targetAccountSid) {
        return new BundleCloneCreator(pathBundleSid, targetAccountSid);
    }

    public static BundleClone fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BundleClone.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BundleClone fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, BundleClone.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BundleClone(@JsonProperty(value="bundle_sid") String bundleSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="regulation_sid") String regulationSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") Status status, @JsonProperty(value="valid_until") String validUntil, @JsonProperty(value="email") String email, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.bundleSid = bundleSid;
        this.accountSid = accountSid;
        this.regulationSid = regulationSid;
        this.friendlyName = friendlyName;
        this.status = status;
        this.validUntil = DateConverter.iso8601DateTimeFromString(validUntil);
        this.email = email;
        this.statusCallback = statusCallback;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getBundleSid() {
        return this.bundleSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getRegulationSid() {
        return this.regulationSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final ZonedDateTime getValidUntil() {
        return this.validUntil;
    }

    public final String getEmail() {
        return this.email;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleClone other = (BundleClone)o;
        return Objects.equals(this.bundleSid, other.bundleSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.regulationSid, other.regulationSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.validUntil, other.validUntil) && Objects.equals(this.email, other.email) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bundleSid, this.accountSid, this.regulationSid, this.friendlyName, this.status, this.validUntil, this.email, this.statusCallback, this.dateCreated, this.dateUpdated, this.url});
    }

    public String toString() {
        return "BundleClone(bundleSid=" + this.getBundleSid() + ", accountSid=" + this.getAccountSid() + ", regulationSid=" + this.getRegulationSid() + ", friendlyName=" + this.getFriendlyName() + ", status=" + (Object)((Object)this.getStatus()) + ", validUntil=" + this.getValidUntil() + ", email=" + this.getEmail() + ", statusCallback=" + this.getStatusCallback() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }

    public static enum Status {
        DRAFT("draft"),
        PENDING_REVIEW("pending-review"),
        IN_REVIEW("in-review"),
        TWILIO_REJECTED("twilio-rejected"),
        TWILIO_APPROVED("twilio-approved"),
        PROVISIONALLY_APPROVED("provisionally-approved");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

