/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.authorizationdocument;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.authorizationdocument.DependentHostedNumberOrder;
import com.twilio.type.PhoneNumber;

public class DependentHostedNumberOrderReader
extends Reader<DependentHostedNumberOrder> {
    private String pathSigningDocumentSid;
    private DependentHostedNumberOrder.Status status;
    private PhoneNumber phoneNumber;
    private String incomingPhoneNumberSid;
    private String friendlyName;
    private Integer pageSize;

    public DependentHostedNumberOrderReader(String pathSigningDocumentSid) {
        this.pathSigningDocumentSid = pathSigningDocumentSid;
    }

    public DependentHostedNumberOrderReader setStatus(DependentHostedNumberOrder.Status status) {
        this.status = status;
        return this;
    }

    public DependentHostedNumberOrderReader setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public DependentHostedNumberOrderReader setPhoneNumber(String phoneNumber) {
        return this.setPhoneNumber(Promoter.phoneNumberFromString(phoneNumber));
    }

    public DependentHostedNumberOrderReader setIncomingPhoneNumberSid(String incomingPhoneNumberSid) {
        this.incomingPhoneNumberSid = incomingPhoneNumberSid;
        return this;
    }

    public DependentHostedNumberOrderReader setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DependentHostedNumberOrderReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<DependentHostedNumberOrder> read(TwilioRestClient client) {
        return new ResourceSet<DependentHostedNumberOrder>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DependentHostedNumberOrder> firstPage(TwilioRestClient client) {
        String path = "/v2/HostedNumber/AuthorizationDocuments/{SigningDocumentSid}/DependentHostedNumberOrders";
        path = path.replace("{SigningDocumentSid}", this.pathSigningDocumentSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<DependentHostedNumberOrder> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DependentHostedNumberOrder read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("items", response.getContent(), DependentHostedNumberOrder.class, client.getObjectMapper());
    }

    @Override
    public Page<DependentHostedNumberOrder> previousPage(Page<DependentHostedNumberOrder> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DependentHostedNumberOrder> nextPage(Page<DependentHostedNumberOrder> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DependentHostedNumberOrder> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.phoneNumber != null) {
            request.addQueryParam("PhoneNumber", this.phoneNumber.toString());
        }
        if (this.incomingPhoneNumberSid != null) {
            request.addQueryParam("IncomingPhoneNumberSid", this.incomingPhoneNumberSid);
        }
        if (this.friendlyName != null) {
            request.addQueryParam("FriendlyName", this.friendlyName);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

