/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.EndUserTypeFetcher;
import com.twilio.rest.numbers.v2.regulatorycompliance.EndUserTypeReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EndUserType
extends Resource {
    private static final long serialVersionUID = 67038001521206L;
    private final String sid;
    private final String friendlyName;
    private final String machineName;
    private final List<Map<String, Object>> fields;
    private final URI url;

    public static EndUserTypeFetcher fetcher(String pathSid) {
        return new EndUserTypeFetcher(pathSid);
    }

    public static EndUserTypeReader reader() {
        return new EndUserTypeReader();
    }

    public static EndUserType fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EndUserType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static EndUserType fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, EndUserType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private EndUserType(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="machine_name") String machineName, @JsonProperty(value="fields") List<Map<String, Object>> fields, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.machineName = machineName;
        this.fields = fields;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getMachineName() {
        return this.machineName;
    }

    public final List<Map<String, Object>> getFields() {
        return this.fields;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndUserType other = (EndUserType)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.machineName, other.machineName) && Objects.equals(this.fields, other.fields) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.friendlyName, this.machineName, this.fields, this.url);
    }

    public String toString() {
        return "EndUserType(sid=" + this.getSid() + ", friendlyName=" + this.getFriendlyName() + ", machineName=" + this.getMachineName() + ", fields=" + this.getFields() + ", url=" + this.getUrl() + ")";
    }
}

