/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance.bundle;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.numbers.v2.regulatorycompliance.bundle.Evaluation;

public class EvaluationReader
extends Reader<Evaluation> {
    private String pathBundleSid;
    private Integer pageSize;

    public EvaluationReader(String pathBundleSid) {
        this.pathBundleSid = pathBundleSid;
    }

    public EvaluationReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<Evaluation> read(TwilioRestClient client) {
        return new ResourceSet<Evaluation>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Evaluation> firstPage(TwilioRestClient client) {
        String path = "/v2/RegulatoryCompliance/Bundles/{BundleSid}/Evaluations";
        path = path.replace("{BundleSid}", this.pathBundleSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.NUMBERS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<Evaluation> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Evaluation read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), Evaluation.class, client.getObjectMapper());
    }

    @Override
    public Page<Evaluation> previousPage(Page<Evaluation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Evaluation> nextPage(Page<Evaluation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NUMBERS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Evaluation> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

