/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.SyncList;

public class SyncListCreator
extends Creator<SyncList> {
    private String pathServiceSid;
    private String uniqueName;

    public SyncListCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public SyncListCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    @Override
    public SyncList create(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Lists";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncList creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SyncList.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
    }
}

