/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.synclist;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.synclist.SyncListPermission;

public class SyncListPermissionFetcher
extends Fetcher<SyncListPermission> {
    private String pathServiceSid;
    private String pathListSid;
    private String pathIdentity;

    public SyncListPermissionFetcher(String pathServiceSid, String pathListSid, String pathIdentity) {
        this.pathServiceSid = pathServiceSid;
        this.pathListSid = pathListSid;
        this.pathIdentity = pathIdentity;
    }

    @Override
    public SyncListPermission fetch(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Lists/{ListSid}/Permissions/{Identity}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{ListSid}", this.pathListSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncListPermission fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SyncListPermission.fromJson(response.getStream(), client.getObjectMapper());
    }
}

