/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service.syncmap;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.syncmap.SyncMapItem;

public class SyncMapItemFetcher
extends Fetcher<SyncMapItem> {
    private String pathServiceSid;
    private String pathMapSid;
    private String pathKey;

    public SyncMapItemFetcher(String pathServiceSid, String pathMapSid, String pathKey) {
        this.pathServiceSid = pathServiceSid;
        this.pathMapSid = pathMapSid;
        this.pathKey = pathKey;
    }

    @Override
    public SyncMapItem fetch(TwilioRestClient client) {
        String path = "/Sync/Services/{ServiceSid}/Maps/{MapSid}/Items/{Key}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{MapSid}", this.pathMapSid.toString());
        path = path.replace("{Key}", this.pathKey.toString());
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncMapItem fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return SyncMapItem.fromJson(response.getStream(), client.getObjectMapper());
    }
}

