/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.bearertoken.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.previewiam.organizations.AccountFetcher;
import com.twilio.rest.previewiam.organizations.AccountReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Account
extends Resource {
    private static final long serialVersionUID = 140632441815443L;
    private final String accountSid;
    private final String friendlyName;
    private final StatusEnum status;
    private final String ownerSid;
    private final ZonedDateTime dateCreated;

    public static AccountFetcher fetcher(String pathOrganizationSid, String pathAccountSid) {
        return new AccountFetcher(pathOrganizationSid, pathAccountSid);
    }

    public static AccountReader reader(String pathOrganizationSid) {
        return new AccountReader(pathOrganizationSid);
    }

    public static Account fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Account.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Account fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Account.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Account(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") StatusEnum status, @JsonProperty(value="owner_sid") String ownerSid, @JsonProperty(value="date_created") String dateCreated) {
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.status = status;
        this.ownerSid = ownerSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final StatusEnum getStatus() {
        return this.status;
    }

    public final String getOwnerSid() {
        return this.ownerSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account other = (Account)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.ownerSid, other.ownerSid) && Objects.equals(this.dateCreated, other.dateCreated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.friendlyName, this.status, this.ownerSid, this.dateCreated});
    }

    public String toString() {
        return "Account(accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", status=" + (Object)((Object)this.getStatus()) + ", ownerSid=" + this.getOwnerSid() + ", dateCreated=" + this.getDateCreated() + ")";
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        SUSPENDED("suspended"),
        PENDING_CLOSURE("pending_closure"),
        CLOSED("closed");

        private final String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static StatusEnum forValue(String value) {
            return (StatusEnum)Promoter.enumFromString((String)value, (Enum[])StatusEnum.values());
        }
    }
}

