/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.previewiam.organizations;

import com.twilio.base.bearertoken.Page;
import com.twilio.base.bearertoken.Reader;
import com.twilio.base.bearertoken.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Response;
import com.twilio.http.bearertoken.BearerTokenRequest;
import com.twilio.http.bearertoken.BearerTokenTwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.previewiam.organizations.RoleAssignment;

public class RoleAssignmentReader
extends Reader<RoleAssignment> {
    private String pathOrganizationSid;
    private Integer pageSize;
    private String identity;
    private String scope;

    public RoleAssignmentReader(String pathOrganizationSid) {
        this.pathOrganizationSid = pathOrganizationSid;
    }

    public RoleAssignmentReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public RoleAssignmentReader setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public RoleAssignmentReader setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public ResourceSet<RoleAssignment> read(BearerTokenTwilioRestClient client) {
        return new ResourceSet<RoleAssignment>(this, client, this.firstPage(client));
    }

    @Override
    public Page<RoleAssignment> firstPage(BearerTokenTwilioRestClient client) {
        String path = "/Organizations/{OrganizationSid}/RoleAssignments";
        path = path.replace("{OrganizationSid}", this.pathOrganizationSid.toString());
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, Domains.PREVIEWIAM.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<RoleAssignment> pageForRequest(BearerTokenTwilioRestClient client, BearerTokenRequest request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RoleAssignment read failed: Unable to connect to server");
        }
        if (!BearerTokenTwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("content", response.getContent(), RoleAssignment.class, client.getObjectMapper());
    }

    @Override
    public Page<RoleAssignment> previousPage(Page<RoleAssignment> page, BearerTokenTwilioRestClient client) {
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEWIAM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RoleAssignment> nextPage(Page<RoleAssignment> page, BearerTokenTwilioRestClient client) {
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEWIAM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<RoleAssignment> getPage(String targetUrl, BearerTokenTwilioRestClient client) {
        BearerTokenRequest request = new BearerTokenRequest(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(BearerTokenRequest request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.identity != null) {
            request.addQueryParam("Identity", this.identity);
        }
        if (this.scope != null) {
            request.addQueryParam("Scope", this.scope);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

