/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v2;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.pricing.v2.Country;

public class CountryFetcher
extends Fetcher<Country> {
    private String pathIsoCountry;

    public CountryFetcher(String pathIsoCountry) {
        this.pathIsoCountry = pathIsoCountry;
    }

    @Override
    public Country fetch(TwilioRestClient client) {
        String path = "/v2/Trunking/Countries/{IsoCountry}";
        path = path.replace("{IsoCountry}", this.pathIsoCountry.toString());
        Request request = new Request(HttpMethod.GET, Domains.PRICING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Country fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Country.fromJson(response.getStream(), client.getObjectMapper());
    }
}

