/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.routes.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.routes.v2.SipDomainFetcher;
import com.twilio.rest.routes.v2.SipDomainUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SipDomain
extends Resource {
    private static final long serialVersionUID = 81903226613345L;
    private final String sipDomain;
    private final URI url;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String voiceRegion;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static SipDomainFetcher fetcher(String pathSipDomain) {
        return new SipDomainFetcher(pathSipDomain);
    }

    public static SipDomainUpdater updater(String pathSipDomain) {
        return new SipDomainUpdater(pathSipDomain);
    }

    public static SipDomain fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SipDomain.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SipDomain fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SipDomain.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SipDomain(@JsonProperty(value="sip_domain") String sipDomain, @JsonProperty(value="url") URI url, @JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="voice_region") String voiceRegion, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sipDomain = sipDomain;
        this.url = url;
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.voiceRegion = voiceRegion;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSipDomain() {
        return this.sipDomain;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getVoiceRegion() {
        return this.voiceRegion;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SipDomain other = (SipDomain)o;
        return Objects.equals(this.sipDomain, other.sipDomain) && Objects.equals(this.url, other.url) && Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.voiceRegion, other.voiceRegion) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.sipDomain, this.url, this.sid, this.accountSid, this.friendlyName, this.voiceRegion, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "SipDomain(sipDomain=" + this.getSipDomain() + ", url=" + this.getUrl() + ", sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", friendlyName=" + this.getFriendlyName() + ", voiceRegion=" + this.getVoiceRegion() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }
}

