/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.routes.v2;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.routes.v2.Trunk;

public class TrunkFetcher
extends Fetcher<Trunk> {
    private String pathSipTrunkDomain;

    public TrunkFetcher(String pathSipTrunkDomain) {
        this.pathSipTrunkDomain = pathSipTrunkDomain;
    }

    @Override
    public Trunk fetch(TwilioRestClient client) {
        String path = "/v2/Trunks/{SipTrunkDomain}";
        path = path.replace("{SipTrunkDomain}", this.pathSipTrunkDomain.toString());
        Request request = new Request(HttpMethod.GET, Domains.ROUTES.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trunk fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Trunk.fromJson(response.getStream(), client.getObjectMapper());
    }
}

