/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.Build;
import java.util.List;

public class BuildCreator
extends Creator<Build> {
    private String pathServiceSid;
    private List<String> assetVersions;
    private List<String> functionVersions;
    private String dependencies;
    private String runtime;

    public BuildCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public BuildCreator setAssetVersions(List<String> assetVersions) {
        this.assetVersions = assetVersions;
        return this;
    }

    public BuildCreator setAssetVersions(String assetVersions) {
        return this.setAssetVersions(Promoter.listOfOne(assetVersions));
    }

    public BuildCreator setFunctionVersions(List<String> functionVersions) {
        this.functionVersions = functionVersions;
        return this;
    }

    public BuildCreator setFunctionVersions(String functionVersions) {
        return this.setFunctionVersions(Promoter.listOfOne(functionVersions));
    }

    public BuildCreator setDependencies(String dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public BuildCreator setRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    @Override
    public Build create(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Builds";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SERVERLESS.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Build creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Build.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.assetVersions != null) {
            for (String prop : this.assetVersions) {
                request.addPostParam("AssetVersions", prop);
            }
        }
        if (this.functionVersions != null) {
            for (String prop : this.functionVersions) {
                request.addPostParam("FunctionVersions", prop);
            }
        }
        if (this.dependencies != null) {
            request.addPostParam("Dependencies", this.dependencies);
        }
        if (this.runtime != null) {
            request.addPostParam("Runtime", this.runtime);
        }
    }
}

