/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.asset;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.asset.AssetVersion;

public class AssetVersionReader
extends Reader<AssetVersion> {
    private String pathServiceSid;
    private String pathAssetSid;
    private Integer pageSize;

    public AssetVersionReader(String pathServiceSid, String pathAssetSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathAssetSid = pathAssetSid;
    }

    public AssetVersionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<AssetVersion> read(TwilioRestClient client) {
        return new ResourceSet<AssetVersion>(this, client, this.firstPage(client));
    }

    @Override
    public Page<AssetVersion> firstPage(TwilioRestClient client) {
        String path = "/v1/Services/{ServiceSid}/Assets/{AssetSid}/Versions";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{AssetSid}", this.pathAssetSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SERVERLESS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<AssetVersion> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AssetVersion read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("asset_versions", response.getContent(), AssetVersion.class, client.getObjectMapper());
    }

    @Override
    public Page<AssetVersion> previousPage(Page<AssetVersion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SERVERLESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AssetVersion> nextPage(Page<AssetVersion> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SERVERLESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<AssetVersion> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

