/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v1.flow.EngagementCreator;
import com.twilio.rest.studio.v1.flow.EngagementDeleter;
import com.twilio.rest.studio.v1.flow.EngagementFetcher;
import com.twilio.rest.studio.v1.flow.EngagementReader;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Engagement
extends Resource {
    private static final long serialVersionUID = 71723617578664L;
    private final String sid;
    private final String accountSid;
    private final String flowSid;
    private final String contactSid;
    private final String contactChannelAddress;
    private final Map<String, Object> context;
    private final Status status;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static EngagementCreator creator(String pathFlowSid, PhoneNumber to, PhoneNumber from) {
        return new EngagementCreator(pathFlowSid, to, from);
    }

    public static EngagementDeleter deleter(String pathFlowSid, String pathSid) {
        return new EngagementDeleter(pathFlowSid, pathSid);
    }

    public static EngagementFetcher fetcher(String pathFlowSid, String pathSid) {
        return new EngagementFetcher(pathFlowSid, pathSid);
    }

    public static EngagementReader reader(String pathFlowSid) {
        return new EngagementReader(pathFlowSid);
    }

    public static Engagement fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Engagement.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Engagement fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Engagement.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Engagement(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="flow_sid") String flowSid, @JsonProperty(value="contact_sid") String contactSid, @JsonProperty(value="contact_channel_address") String contactChannelAddress, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="status") Status status, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.flowSid = flowSid;
        this.contactSid = contactSid;
        this.contactChannelAddress = contactChannelAddress;
        this.context = context;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFlowSid() {
        return this.flowSid;
    }

    public final String getContactSid() {
        return this.contactSid;
    }

    public final String getContactChannelAddress() {
        return this.contactChannelAddress;
    }

    public final Map<String, Object> getContext() {
        return this.context;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Engagement other = (Engagement)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.flowSid, other.flowSid) && Objects.equals(this.contactSid, other.contactSid) && Objects.equals(this.contactChannelAddress, other.contactChannelAddress) && Objects.equals(this.context, other.context) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.flowSid, this.contactSid, this.contactChannelAddress, this.context, this.status, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return "Engagement(sid=" + this.getSid() + ", accountSid=" + this.getAccountSid() + ", flowSid=" + this.getFlowSid() + ", contactSid=" + this.getContactSid() + ", contactChannelAddress=" + this.getContactChannelAddress() + ", context=" + this.getContext() + ", status=" + (Object)((Object)this.getStatus()) + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum Status {
        ACTIVE("active"),
        ENDED("ended");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

