/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2.flow.execution;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.flow.execution.ExecutionStep;

public class ExecutionStepFetcher
extends Fetcher<ExecutionStep> {
    private String pathFlowSid;
    private String pathExecutionSid;
    private String pathSid;

    public ExecutionStepFetcher(String pathFlowSid, String pathExecutionSid, String pathSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathExecutionSid = pathExecutionSid;
        this.pathSid = pathSid;
    }

    @Override
    public ExecutionStep fetch(TwilioRestClient client) {
        String path = "/v2/Flows/{FlowSid}/Executions/{ExecutionSid}/Steps/{Sid}";
        path = path.replace("{FlowSid}", this.pathFlowSid.toString());
        path = path.replace("{ExecutionSid}", this.pathExecutionSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ExecutionStep fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ExecutionStep.fromJson(response.getStream(), client.getObjectMapper());
    }
}

