/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Fleet;
import java.net.URI;

public class FleetUpdater
extends Updater<Fleet> {
    private String pathSid;
    private String uniqueName;
    private String networkAccessProfile;
    private URI ipCommandsUrl;
    private HttpMethod ipCommandsMethod;
    private URI smsCommandsUrl;
    private HttpMethod smsCommandsMethod;
    private Integer dataLimit;

    public FleetUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public FleetUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public FleetUpdater setNetworkAccessProfile(String networkAccessProfile) {
        this.networkAccessProfile = networkAccessProfile;
        return this;
    }

    public FleetUpdater setIpCommandsUrl(URI ipCommandsUrl) {
        this.ipCommandsUrl = ipCommandsUrl;
        return this;
    }

    public FleetUpdater setIpCommandsUrl(String ipCommandsUrl) {
        return this.setIpCommandsUrl(Promoter.uriFromString(ipCommandsUrl));
    }

    public FleetUpdater setIpCommandsMethod(HttpMethod ipCommandsMethod) {
        this.ipCommandsMethod = ipCommandsMethod;
        return this;
    }

    public FleetUpdater setSmsCommandsUrl(URI smsCommandsUrl) {
        this.smsCommandsUrl = smsCommandsUrl;
        return this;
    }

    public FleetUpdater setSmsCommandsUrl(String smsCommandsUrl) {
        return this.setSmsCommandsUrl(Promoter.uriFromString(smsCommandsUrl));
    }

    public FleetUpdater setSmsCommandsMethod(HttpMethod smsCommandsMethod) {
        this.smsCommandsMethod = smsCommandsMethod;
        return this;
    }

    public FleetUpdater setDataLimit(Integer dataLimit) {
        this.dataLimit = dataLimit;
        return this;
    }

    @Override
    public Fleet update(TwilioRestClient client) {
        String path = "/v1/Fleets/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fleet update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Fleet.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.networkAccessProfile != null) {
            request.addPostParam("NetworkAccessProfile", this.networkAccessProfile);
        }
        if (this.ipCommandsUrl != null) {
            request.addPostParam("IpCommandsUrl", this.ipCommandsUrl.toString());
        }
        if (this.ipCommandsMethod != null) {
            request.addPostParam("IpCommandsMethod", this.ipCommandsMethod.toString());
        }
        if (this.smsCommandsUrl != null) {
            request.addPostParam("SmsCommandsUrl", this.smsCommandsUrl.toString());
        }
        if (this.smsCommandsMethod != null) {
            request.addPostParam("SmsCommandsMethod", this.smsCommandsMethod.toString());
        }
        if (this.dataLimit != null) {
            request.addPostParam("DataLimit", this.dataLimit.toString());
        }
    }
}

