/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.IpCommand;

public class IpCommandReader
extends Reader<IpCommand> {
    private String sim;
    private String simIccid;
    private IpCommand.Status status;
    private IpCommand.Direction direction;
    private Integer pageSize;

    public IpCommandReader setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public IpCommandReader setSimIccid(String simIccid) {
        this.simIccid = simIccid;
        return this;
    }

    public IpCommandReader setStatus(IpCommand.Status status) {
        this.status = status;
        return this;
    }

    public IpCommandReader setDirection(IpCommand.Direction direction) {
        this.direction = direction;
        return this;
    }

    public IpCommandReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<IpCommand> read(TwilioRestClient client) {
        return new ResourceSet<IpCommand>(this, client, this.firstPage(client));
    }

    @Override
    public Page<IpCommand> firstPage(TwilioRestClient client) {
        String path = "/v1/IpCommands";
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<IpCommand> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpCommand read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("ip_commands", response.getContent(), IpCommand.class, client.getObjectMapper());
    }

    @Override
    public Page<IpCommand> previousPage(Page<IpCommand> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IpCommand> nextPage(Page<IpCommand> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<IpCommand> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.sim != null) {
            request.addQueryParam("Sim", this.sim);
        }
        if (this.simIccid != null) {
            request.addQueryParam("SimIccid", this.simIccid);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.direction != null) {
            request.addQueryParam("Direction", this.direction.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

