/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.NetworkFetcher;
import com.twilio.rest.supersim.v1.NetworkReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Network
extends Resource {
    private static final long serialVersionUID = 225839080791216L;
    private final String sid;
    private final String friendlyName;
    private final URI url;
    private final String isoCountry;
    private final List<Map<String, Object>> identifiers;

    public static NetworkFetcher fetcher(String pathSid) {
        return new NetworkFetcher(pathSid);
    }

    public static NetworkReader reader() {
        return new NetworkReader();
    }

    public static Network fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Network.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Network fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Network.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Network(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="url") URI url, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="identifiers") List<Map<String, Object>> identifiers) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.url = url;
        this.isoCountry = isoCountry;
        this.identifiers = identifiers;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final List<Map<String, Object>> getIdentifiers() {
        return this.identifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network other = (Network)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.url, other.url) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.identifiers, other.identifiers);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.friendlyName, this.url, this.isoCountry, this.identifiers);
    }

    public String toString() {
        return "Network(sid=" + this.getSid() + ", friendlyName=" + this.getFriendlyName() + ", url=" + this.getUrl() + ", isoCountry=" + this.getIsoCountry() + ", identifiers=" + this.getIdentifiers() + ")";
    }
}

