/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.SettingsUpdateReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SettingsUpdate
extends Resource {
    private static final long serialVersionUID = 126256874693410L;
    private final String sid;
    private final String iccid;
    private final String simSid;
    private final Status status;
    private final List<Map<String, Object>> packages;
    private final ZonedDateTime dateCompleted;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static SettingsUpdateReader reader() {
        return new SettingsUpdateReader();
    }

    public static SettingsUpdate fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SettingsUpdate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SettingsUpdate fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SettingsUpdate.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SettingsUpdate(@JsonProperty(value="sid") String sid, @JsonProperty(value="iccid") String iccid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="status") Status status, @JsonProperty(value="packages") List<Map<String, Object>> packages, @JsonProperty(value="date_completed") String dateCompleted, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.iccid = iccid;
        this.simSid = simSid;
        this.status = status;
        this.packages = packages;
        this.dateCompleted = DateConverter.iso8601DateTimeFromString(dateCompleted);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getIccid() {
        return this.iccid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final List<Map<String, Object>> getPackages() {
        return this.packages;
    }

    public final ZonedDateTime getDateCompleted() {
        return this.dateCompleted;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingsUpdate other = (SettingsUpdate)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.iccid, other.iccid) && Objects.equals(this.simSid, other.simSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.packages, other.packages) && Objects.equals(this.dateCompleted, other.dateCompleted) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.iccid, this.simSid, this.status, this.packages, this.dateCompleted, this.dateCreated, this.dateUpdated});
    }

    public String toString() {
        return "SettingsUpdate(sid=" + this.getSid() + ", iccid=" + this.getIccid() + ", simSid=" + this.getSimSid() + ", status=" + (Object)((Object)this.getStatus()) + ", packages=" + this.getPackages() + ", dateCompleted=" + this.getDateCompleted() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }

    public static enum Status {
        SCHEDULED("scheduled"),
        IN_PROGRESS("in-progress"),
        SUCCESSFUL("successful"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

