/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.SettingsUpdate;

public class SettingsUpdateReader
extends Reader<SettingsUpdate> {
    private String sim;
    private SettingsUpdate.Status status;
    private Integer pageSize;

    public SettingsUpdateReader setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public SettingsUpdateReader setStatus(SettingsUpdate.Status status) {
        this.status = status;
        return this;
    }

    public SettingsUpdateReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SettingsUpdate> read(TwilioRestClient client) {
        return new ResourceSet<SettingsUpdate>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SettingsUpdate> firstPage(TwilioRestClient client) {
        String path = "/v1/SettingsUpdates";
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<SettingsUpdate> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SettingsUpdate read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("settings_updates", response.getContent(), SettingsUpdate.class, client.getObjectMapper());
    }

    @Override
    public Page<SettingsUpdate> previousPage(Page<SettingsUpdate> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SettingsUpdate> nextPage(Page<SettingsUpdate> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SettingsUpdate> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.sim != null) {
            request.addQueryParam("Sim", this.sim);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status.toString());
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

