/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1.networkaccessprofile;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.networkaccessprofile.NetworkAccessProfileNetwork;

public class NetworkAccessProfileNetworkFetcher
extends Fetcher<NetworkAccessProfileNetwork> {
    private String pathNetworkAccessProfileSid;
    private String pathSid;

    public NetworkAccessProfileNetworkFetcher(String pathNetworkAccessProfileSid, String pathSid) {
        this.pathNetworkAccessProfileSid = pathNetworkAccessProfileSid;
        this.pathSid = pathSid;
    }

    @Override
    public NetworkAccessProfileNetwork fetch(TwilioRestClient client) {
        String path = "/v1/NetworkAccessProfiles/{NetworkAccessProfileSid}/Networks/{Sid}";
        path = path.replace("{NetworkAccessProfileSid}", this.pathNetworkAccessProfileSid.toString());
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("NetworkAccessProfileNetwork fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return NetworkAccessProfileNetwork.fromJson(response.getStream(), client.getObjectMapper());
    }
}

