/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Activity;

public class ActivityCreator
extends Creator<Activity> {
    private String pathWorkspaceSid;
    private String friendlyName;
    private Boolean available;

    public ActivityCreator(String pathWorkspaceSid, String friendlyName) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.friendlyName = friendlyName;
    }

    public ActivityCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ActivityCreator setAvailable(Boolean available) {
        this.available = available;
        return this;
    }

    @Override
    public Activity create(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Activities";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Activity creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Activity.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.available != null) {
            request.addPostParam("Available", this.available.toString());
        }
    }
}

