/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.Task;
import java.time.ZonedDateTime;

public class TaskCreator
extends Creator<Task> {
    private String pathWorkspaceSid;
    private Integer timeout;
    private Integer priority;
    private String taskChannel;
    private String workflowSid;
    private String attributes;
    private ZonedDateTime virtualStartTime;
    private String routingTarget;
    private String ignoreCapacity;
    private String taskQueueSid;

    public TaskCreator(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public TaskCreator setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public TaskCreator setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public TaskCreator setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    public TaskCreator setWorkflowSid(String workflowSid) {
        this.workflowSid = workflowSid;
        return this;
    }

    public TaskCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public TaskCreator setVirtualStartTime(ZonedDateTime virtualStartTime) {
        this.virtualStartTime = virtualStartTime;
        return this;
    }

    public TaskCreator setRoutingTarget(String routingTarget) {
        this.routingTarget = routingTarget;
        return this;
    }

    public TaskCreator setIgnoreCapacity(String ignoreCapacity) {
        this.ignoreCapacity = ignoreCapacity;
        return this;
    }

    public TaskCreator setTaskQueueSid(String taskQueueSid) {
        this.taskQueueSid = taskQueueSid;
        return this;
    }

    @Override
    public Task create(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Tasks";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Task creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Task.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.timeout != null) {
            request.addPostParam("Timeout", this.timeout.toString());
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.taskChannel != null) {
            request.addPostParam("TaskChannel", this.taskChannel);
        }
        if (this.workflowSid != null) {
            request.addPostParam("WorkflowSid", this.workflowSid);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.virtualStartTime != null) {
            request.addPostParam("VirtualStartTime", this.virtualStartTime.toInstant().toString());
        }
        if (this.routingTarget != null) {
            request.addPostParam("RoutingTarget", this.routingTarget);
        }
        if (this.ignoreCapacity != null) {
            request.addPostParam("IgnoreCapacity", this.ignoreCapacity);
        }
        if (this.taskQueueSid != null) {
            request.addPostParam("TaskQueueSid", this.taskQueueSid);
        }
    }
}

