/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.taskqueue;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.taskqueue.TaskQueueBulkRealTimeStatistics;

public class TaskQueueBulkRealTimeStatisticsCreator
extends Creator<TaskQueueBulkRealTimeStatistics> {
    private String pathWorkspaceSid;
    private Object body;

    public TaskQueueBulkRealTimeStatisticsCreator(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public TaskQueueBulkRealTimeStatisticsCreator setBody(Object body) {
        this.body = body;
        return this;
    }

    @Override
    public TaskQueueBulkRealTimeStatistics create(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/TaskQueues/RealTimeStatistics";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TASKROUTER.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request, client);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TaskQueueBulkRealTimeStatistics creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return TaskQueueBulkRealTimeStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request, TwilioRestClient client) {
        ObjectMapper objectMapper = client.getObjectMapper();
        if (this.body != null) {
            request.setBody(TaskQueueBulkRealTimeStatistics.toJson(this.body, objectMapper));
        }
    }
}

