/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.twilio.base.Fetcher;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkersCumulativeStatistics;
import java.time.ZonedDateTime;

public class WorkersCumulativeStatisticsFetcher
extends Fetcher<WorkersCumulativeStatistics> {
    private String pathWorkspaceSid;
    private ZonedDateTime endDate;
    private Integer minutes;
    private ZonedDateTime startDate;
    private String taskChannel;

    public WorkersCumulativeStatisticsFetcher(String pathWorkspaceSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
    }

    public WorkersCumulativeStatisticsFetcher setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public WorkersCumulativeStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public WorkersCumulativeStatisticsFetcher setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorkersCumulativeStatisticsFetcher setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    @Override
    public WorkersCumulativeStatistics fetch(TwilioRestClient client) {
        String path = "/v1/Workspaces/{WorkspaceSid}/Workers/CumulativeStatistics";
        path = path.replace("{WorkspaceSid}", this.pathWorkspaceSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WorkersCumulativeStatistics fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return WorkersCumulativeStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toInstant().toString());
        }
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toInstant().toString());
        }
        if (this.taskChannel != null) {
            request.addQueryParam("TaskChannel", this.taskChannel);
        }
    }
}

