/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.trunking.v1.trunk.OriginationUrlCreator;
import com.twilio.rest.trunking.v1.trunk.OriginationUrlDeleter;
import com.twilio.rest.trunking.v1.trunk.OriginationUrlFetcher;
import com.twilio.rest.trunking.v1.trunk.OriginationUrlReader;
import com.twilio.rest.trunking.v1.trunk.OriginationUrlUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OriginationUrl
extends Resource {
    private static final long serialVersionUID = 133388691973992L;
    private final String accountSid;
    private final String sid;
    private final String trunkSid;
    private final Integer weight;
    private final Boolean enabled;
    private final URI sipUrl;
    private final String friendlyName;
    private final Integer priority;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static OriginationUrlCreator creator(String pathTrunkSid, Integer weight, Integer priority, Boolean enabled, String friendlyName, URI sipUrl) {
        return new OriginationUrlCreator(pathTrunkSid, weight, priority, enabled, friendlyName, sipUrl);
    }

    public static OriginationUrlDeleter deleter(String pathTrunkSid, String pathSid) {
        return new OriginationUrlDeleter(pathTrunkSid, pathSid);
    }

    public static OriginationUrlFetcher fetcher(String pathTrunkSid, String pathSid) {
        return new OriginationUrlFetcher(pathTrunkSid, pathSid);
    }

    public static OriginationUrlReader reader(String pathTrunkSid) {
        return new OriginationUrlReader(pathTrunkSid);
    }

    public static OriginationUrlUpdater updater(String pathTrunkSid, String pathSid) {
        return new OriginationUrlUpdater(pathTrunkSid, pathSid);
    }

    public static OriginationUrl fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OriginationUrl.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static OriginationUrl fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, OriginationUrl.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private OriginationUrl(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="weight") Integer weight, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="sip_url") URI sipUrl, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.trunkSid = trunkSid;
        this.weight = weight;
        this.enabled = enabled;
        this.sipUrl = sipUrl;
        this.friendlyName = friendlyName;
        this.priority = priority;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final Integer getWeight() {
        return this.weight;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final URI getSipUrl() {
        return this.sipUrl;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OriginationUrl other = (OriginationUrl)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals(this.weight, other.weight) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.sipUrl, other.sipUrl) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.priority, other.priority) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.trunkSid, this.weight, this.enabled, this.sipUrl, this.friendlyName, this.priority, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return "OriginationUrl(accountSid=" + this.getAccountSid() + ", sid=" + this.getSid() + ", trunkSid=" + this.getTrunkSid() + ", weight=" + this.getWeight() + ", enabled=" + this.getEnabled() + ", sipUrl=" + this.getSipUrl() + ", friendlyName=" + this.getFriendlyName() + ", priority=" + this.getPriority() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

