/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.OriginationUrl;
import java.net.URI;

public class OriginationUrlCreator
extends Creator<OriginationUrl> {
    private String pathTrunkSid;
    private Integer weight;
    private Integer priority;
    private Boolean enabled;
    private String friendlyName;
    private URI sipUrl;

    public OriginationUrlCreator(String pathTrunkSid, Integer weight, Integer priority, Boolean enabled, String friendlyName, URI sipUrl) {
        this.pathTrunkSid = pathTrunkSid;
        this.weight = weight;
        this.priority = priority;
        this.enabled = enabled;
        this.friendlyName = friendlyName;
        this.sipUrl = sipUrl;
    }

    public OriginationUrlCreator setWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    public OriginationUrlCreator setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public OriginationUrlCreator setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OriginationUrlCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public OriginationUrlCreator setSipUrl(URI sipUrl) {
        this.sipUrl = sipUrl;
        return this;
    }

    public OriginationUrlCreator setSipUrl(String sipUrl) {
        return this.setSipUrl(Promoter.uriFromString(sipUrl));
    }

    @Override
    public OriginationUrl create(TwilioRestClient client) {
        String path = "/v1/Trunks/{TrunkSid}/OriginationUrls";
        path = path.replace("{TrunkSid}", this.pathTrunkSid.toString());
        path = path.replace("{Weight}", this.weight.toString());
        path = path.replace("{Priority}", this.priority.toString());
        path = path.replace("{Enabled}", this.enabled.toString());
        path = path.replace("{FriendlyName}", this.friendlyName.toString());
        path = path.replace("{SipUrl}", this.sipUrl.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUNKING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("OriginationUrl creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return OriginationUrl.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.weight != null) {
            request.addPostParam("Weight", this.weight.toString());
        }
        if (this.priority != null) {
            request.addPostParam("Priority", this.priority.toString());
        }
        if (this.enabled != null) {
            request.addPostParam("Enabled", this.enabled.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.sipUrl != null) {
            request.addPostParam("SipUrl", this.sipUrl.toString());
        }
    }
}

