/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trunking.v1.trunk;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trunking.v1.trunk.Recording;

public class RecordingUpdater
extends Updater<Recording> {
    private String pathTrunkSid;
    private Recording.RecordingMode mode;
    private Recording.RecordingTrim trim;

    public RecordingUpdater(String pathTrunkSid) {
        this.pathTrunkSid = pathTrunkSid;
    }

    public RecordingUpdater setMode(Recording.RecordingMode mode) {
        this.mode = mode;
        return this;
    }

    public RecordingUpdater setTrim(Recording.RecordingTrim trim) {
        this.trim = trim;
        return this;
    }

    @Override
    public Recording update(TwilioRestClient client) {
        String path = "/v1/Trunks/{TrunkSid}/Recording";
        path = path.replace("{TrunkSid}", this.pathTrunkSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUNKING.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Recording.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.mode != null) {
            request.addPostParam("Mode", this.mode.toString());
        }
        if (this.trim != null) {
            request.addPostParam("Trim", this.trim.toString());
        }
    }
}

