/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.ComplianceTollfreeInquiries;
import com.twilio.type.PhoneNumber;
import java.util.List;

public class ComplianceTollfreeInquiriesCreator
extends Creator<ComplianceTollfreeInquiries> {
    private PhoneNumber tollfreePhoneNumber;
    private String notificationEmail;
    private String businessName;
    private String businessWebsite;
    private List<String> useCaseCategories;
    private String useCaseSummary;
    private String productionMessageSample;
    private List<String> optInImageUrls;
    private ComplianceTollfreeInquiries.OptInType optInType;
    private String messageVolume;
    private String businessStreetAddress;
    private String businessStreetAddress2;
    private String businessCity;
    private String businessStateProvinceRegion;
    private String businessPostalCode;
    private String businessCountry;
    private String additionalInformation;
    private String businessContactFirstName;
    private String businessContactLastName;
    private String businessContactEmail;
    private PhoneNumber businessContactPhone;
    private String themeSetId;
    private Boolean skipMessagingUseCase;

    public ComplianceTollfreeInquiriesCreator(PhoneNumber tollfreePhoneNumber, String notificationEmail) {
        this.tollfreePhoneNumber = tollfreePhoneNumber;
        this.notificationEmail = notificationEmail;
    }

    public ComplianceTollfreeInquiriesCreator setTollfreePhoneNumber(PhoneNumber tollfreePhoneNumber) {
        this.tollfreePhoneNumber = tollfreePhoneNumber;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setTollfreePhoneNumber(String tollfreePhoneNumber) {
        return this.setTollfreePhoneNumber(Promoter.phoneNumberFromString(tollfreePhoneNumber));
    }

    public ComplianceTollfreeInquiriesCreator setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessName(String businessName) {
        this.businessName = businessName;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessWebsite(String businessWebsite) {
        this.businessWebsite = businessWebsite;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setUseCaseCategories(List<String> useCaseCategories) {
        this.useCaseCategories = useCaseCategories;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setUseCaseCategories(String useCaseCategories) {
        return this.setUseCaseCategories(Promoter.listOfOne(useCaseCategories));
    }

    public ComplianceTollfreeInquiriesCreator setUseCaseSummary(String useCaseSummary) {
        this.useCaseSummary = useCaseSummary;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setProductionMessageSample(String productionMessageSample) {
        this.productionMessageSample = productionMessageSample;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setOptInImageUrls(List<String> optInImageUrls) {
        this.optInImageUrls = optInImageUrls;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setOptInImageUrls(String optInImageUrls) {
        return this.setOptInImageUrls(Promoter.listOfOne(optInImageUrls));
    }

    public ComplianceTollfreeInquiriesCreator setOptInType(ComplianceTollfreeInquiries.OptInType optInType) {
        this.optInType = optInType;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setMessageVolume(String messageVolume) {
        this.messageVolume = messageVolume;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessStreetAddress(String businessStreetAddress) {
        this.businessStreetAddress = businessStreetAddress;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessStreetAddress2(String businessStreetAddress2) {
        this.businessStreetAddress2 = businessStreetAddress2;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessCity(String businessCity) {
        this.businessCity = businessCity;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessStateProvinceRegion(String businessStateProvinceRegion) {
        this.businessStateProvinceRegion = businessStateProvinceRegion;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessPostalCode(String businessPostalCode) {
        this.businessPostalCode = businessPostalCode;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessCountry(String businessCountry) {
        this.businessCountry = businessCountry;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessContactFirstName(String businessContactFirstName) {
        this.businessContactFirstName = businessContactFirstName;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessContactLastName(String businessContactLastName) {
        this.businessContactLastName = businessContactLastName;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessContactEmail(String businessContactEmail) {
        this.businessContactEmail = businessContactEmail;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessContactPhone(PhoneNumber businessContactPhone) {
        this.businessContactPhone = businessContactPhone;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setBusinessContactPhone(String businessContactPhone) {
        return this.setBusinessContactPhone(Promoter.phoneNumberFromString(businessContactPhone));
    }

    public ComplianceTollfreeInquiriesCreator setThemeSetId(String themeSetId) {
        this.themeSetId = themeSetId;
        return this;
    }

    public ComplianceTollfreeInquiriesCreator setSkipMessagingUseCase(Boolean skipMessagingUseCase) {
        this.skipMessagingUseCase = skipMessagingUseCase;
        return this;
    }

    @Override
    public ComplianceTollfreeInquiries create(TwilioRestClient client) {
        String path = "/v1/ComplianceInquiries/Tollfree/Initialize";
        path = path.replace("{TollfreePhoneNumber}", this.tollfreePhoneNumber.encode("utf-8"));
        path = path.replace("{NotificationEmail}", this.notificationEmail.toString());
        Request request = new Request(HttpMethod.POST, Domains.TRUSTHUB.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ComplianceTollfreeInquiries creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return ComplianceTollfreeInquiries.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.tollfreePhoneNumber != null) {
            request.addPostParam("TollfreePhoneNumber", this.tollfreePhoneNumber.toString());
        }
        if (this.notificationEmail != null) {
            request.addPostParam("NotificationEmail", this.notificationEmail);
        }
        if (this.businessName != null) {
            request.addPostParam("BusinessName", this.businessName);
        }
        if (this.businessWebsite != null) {
            request.addPostParam("BusinessWebsite", this.businessWebsite);
        }
        if (this.useCaseCategories != null) {
            for (String prop : this.useCaseCategories) {
                request.addPostParam("UseCaseCategories", prop);
            }
        }
        if (this.useCaseSummary != null) {
            request.addPostParam("UseCaseSummary", this.useCaseSummary);
        }
        if (this.productionMessageSample != null) {
            request.addPostParam("ProductionMessageSample", this.productionMessageSample);
        }
        if (this.optInImageUrls != null) {
            for (String prop : this.optInImageUrls) {
                request.addPostParam("OptInImageUrls", prop);
            }
        }
        if (this.optInType != null) {
            request.addPostParam("OptInType", this.optInType.toString());
        }
        if (this.messageVolume != null) {
            request.addPostParam("MessageVolume", this.messageVolume);
        }
        if (this.businessStreetAddress != null) {
            request.addPostParam("BusinessStreetAddress", this.businessStreetAddress);
        }
        if (this.businessStreetAddress2 != null) {
            request.addPostParam("BusinessStreetAddress2", this.businessStreetAddress2);
        }
        if (this.businessCity != null) {
            request.addPostParam("BusinessCity", this.businessCity);
        }
        if (this.businessStateProvinceRegion != null) {
            request.addPostParam("BusinessStateProvinceRegion", this.businessStateProvinceRegion);
        }
        if (this.businessPostalCode != null) {
            request.addPostParam("BusinessPostalCode", this.businessPostalCode);
        }
        if (this.businessCountry != null) {
            request.addPostParam("BusinessCountry", this.businessCountry);
        }
        if (this.additionalInformation != null) {
            request.addPostParam("AdditionalInformation", this.additionalInformation);
        }
        if (this.businessContactFirstName != null) {
            request.addPostParam("BusinessContactFirstName", this.businessContactFirstName);
        }
        if (this.businessContactLastName != null) {
            request.addPostParam("BusinessContactLastName", this.businessContactLastName);
        }
        if (this.businessContactEmail != null) {
            request.addPostParam("BusinessContactEmail", this.businessContactEmail);
        }
        if (this.businessContactPhone != null) {
            request.addPostParam("BusinessContactPhone", this.businessContactPhone.toString());
        }
        if (this.themeSetId != null) {
            request.addPostParam("ThemeSetId", this.themeSetId);
        }
        if (this.skipMessagingUseCase != null) {
            request.addPostParam("SkipMessagingUseCase", this.skipMessagingUseCase.toString());
        }
    }
}

