/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.trusthub.v1.trustproducts;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.trusthub.v1.trustproducts.TrustProductsChannelEndpointAssignment;

public class TrustProductsChannelEndpointAssignmentReader
extends Reader<TrustProductsChannelEndpointAssignment> {
    private String pathTrustProductSid;
    private String channelEndpointSid;
    private String channelEndpointSids;
    private Integer pageSize;

    public TrustProductsChannelEndpointAssignmentReader(String pathTrustProductSid) {
        this.pathTrustProductSid = pathTrustProductSid;
    }

    public TrustProductsChannelEndpointAssignmentReader setChannelEndpointSid(String channelEndpointSid) {
        this.channelEndpointSid = channelEndpointSid;
        return this;
    }

    public TrustProductsChannelEndpointAssignmentReader setChannelEndpointSids(String channelEndpointSids) {
        this.channelEndpointSids = channelEndpointSids;
        return this;
    }

    public TrustProductsChannelEndpointAssignmentReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<TrustProductsChannelEndpointAssignment> read(TwilioRestClient client) {
        return new ResourceSet<TrustProductsChannelEndpointAssignment>(this, client, this.firstPage(client));
    }

    @Override
    public Page<TrustProductsChannelEndpointAssignment> firstPage(TwilioRestClient client) {
        String path = "/v1/TrustProducts/{TrustProductSid}/ChannelEndpointAssignments";
        path = path.replace("{TrustProductSid}", this.pathTrustProductSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.TRUSTHUB.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<TrustProductsChannelEndpointAssignment> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("TrustProductsChannelEndpointAssignment read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("results", response.getContent(), TrustProductsChannelEndpointAssignment.class, client.getObjectMapper());
    }

    @Override
    public Page<TrustProductsChannelEndpointAssignment> previousPage(Page<TrustProductsChannelEndpointAssignment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TrustProductsChannelEndpointAssignment> nextPage(Page<TrustProductsChannelEndpointAssignment> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.TRUSTHUB.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<TrustProductsChannelEndpointAssignment> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.channelEndpointSid != null) {
            request.addQueryParam("ChannelEndpointSid", this.channelEndpointSid);
        }
        if (this.channelEndpointSids != null) {
            request.addQueryParam("ChannelEndpointSids", this.channelEndpointSids);
        }
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

