/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.SafelistCreator;
import com.twilio.rest.verify.v2.SafelistDeleter;
import com.twilio.rest.verify.v2.SafelistFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Safelist
extends Resource {
    private static final long serialVersionUID = 83566412587236L;
    private final String sid;
    private final String phoneNumber;
    private final URI url;

    public static SafelistCreator creator(String phoneNumber) {
        return new SafelistCreator(phoneNumber);
    }

    public static SafelistDeleter deleter(String pathPhoneNumber) {
        return new SafelistDeleter(pathPhoneNumber);
    }

    public static SafelistFetcher fetcher(String pathPhoneNumber) {
        return new SafelistFetcher(pathPhoneNumber);
    }

    public static Safelist fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Safelist.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Safelist fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Safelist.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Safelist(@JsonProperty(value="sid") String sid, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.phoneNumber = phoneNumber;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getPhoneNumber() {
        return this.phoneNumber;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Safelist other = (Safelist)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.phoneNumber, this.url);
    }

    public String toString() {
        return "Safelist(sid=" + this.getSid() + ", phoneNumber=" + this.getPhoneNumber() + ", url=" + this.getUrl() + ")";
    }
}

