/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service.entity.challenge;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.entity.challenge.Notification;

public class NotificationCreator
extends Creator<Notification> {
    private String pathServiceSid;
    private String pathIdentity;
    private String pathChallengeSid;
    private Integer ttl;

    public NotificationCreator(String pathServiceSid, String pathIdentity, String pathChallengeSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.pathChallengeSid = pathChallengeSid;
    }

    public NotificationCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public Notification create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Entities/{Identity}/Challenges/{ChallengeSid}/Notifications";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.pathIdentity.toString());
        path = path.replace("{ChallengeSid}", this.pathChallengeSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Notification creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Notification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
    }
}

