/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.room.RecordingRulesFetcher;
import com.twilio.rest.video.v1.room.RecordingRulesUpdater;
import com.twilio.type.RecordingRule;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RecordingRules
extends Resource {
    private static final long serialVersionUID = 215198002775360L;
    private final String roomSid;
    private final List<RecordingRule> rules;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static RecordingRulesFetcher fetcher(String pathRoomSid) {
        return new RecordingRulesFetcher(pathRoomSid);
    }

    public static RecordingRulesUpdater updater(String pathRoomSid) {
        return new RecordingRulesUpdater(pathRoomSid);
    }

    public static RecordingRules fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, RecordingRules.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static RecordingRules fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, RecordingRules.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private RecordingRules(@JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="rules") List<RecordingRule> rules, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.roomSid = roomSid;
        this.rules = rules;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final List<RecordingRule> getRules() {
        return this.rules;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingRules other = (RecordingRules)o;
        return Objects.equals(this.roomSid, other.roomSid) && Objects.equals(this.rules, other.rules) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.roomSid, this.rules, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "RecordingRules(roomSid=" + this.getRoomSid() + ", rules=" + this.getRules() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }
}

