/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.participant.SubscribedTrack;

public class SubscribedTrackReader
extends Reader<SubscribedTrack> {
    private String pathRoomSid;
    private String pathParticipantSid;
    private Integer pageSize;

    public SubscribedTrackReader(String pathRoomSid, String pathParticipantSid) {
        this.pathRoomSid = pathRoomSid;
        this.pathParticipantSid = pathParticipantSid;
    }

    public SubscribedTrackReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<SubscribedTrack> read(TwilioRestClient client) {
        return new ResourceSet<SubscribedTrack>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SubscribedTrack> firstPage(TwilioRestClient client) {
        String path = "/v1/Rooms/{RoomSid}/Participants/{ParticipantSid}/SubscribedTracks";
        path = path.replace("{RoomSid}", this.pathRoomSid.toString());
        path = path.replace("{ParticipantSid}", this.pathParticipantSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<SubscribedTrack> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SubscribedTrack read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("subscribed_tracks", response.getContent(), SubscribedTrack.class, client.getObjectMapper());
    }

    @Override
    public Page<SubscribedTrack> previousPage(Page<SubscribedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> nextPage(Page<SubscribedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

