/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1.sim;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.wireless.v1.sim.DataSession;

public class DataSessionReader
extends Reader<DataSession> {
    private String pathSimSid;
    private Integer pageSize;

    public DataSessionReader(String pathSimSid) {
        this.pathSimSid = pathSimSid;
    }

    public DataSessionReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<DataSession> read(TwilioRestClient client) {
        return new ResourceSet<DataSession>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DataSession> firstPage(TwilioRestClient client) {
        String path = "/v1/Sims/{SimSid}/DataSessions";
        path = path.replace("{SimSid}", this.pathSimSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.WIRELESS.toString(), path);
        this.addQueryParams(request);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        return this.pageForRequest(client, request);
    }

    private Page<DataSession> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DataSession read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("data_sessions", response.getContent(), DataSession.class, client.getObjectMapper());
    }

    @Override
    public Page<DataSession> previousPage(Page<DataSession> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.WIRELESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DataSession> nextPage(Page<DataSession> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.WIRELESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DataSession> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

