/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.taskrouter.TaskRouterResource;
import com.twilio.taskrouter.WorkflowRuleTarget;
import java.io.IOException;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowRule
extends TaskRouterResource {
    private final String expression;
    private final String friendlyName;
    private final List<WorkflowRuleTarget> targets;

    @JsonCreator
    private WorkflowRule(@JsonProperty(value="expression") String expression, @JsonProperty(value="filter_friendly_name") String filterFriendlyName, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="targets") List<WorkflowRuleTarget> targets) {
        this.expression = expression;
        this.friendlyName = friendlyName != null ? friendlyName : filterFriendlyName;
        this.targets = targets;
    }

    private WorkflowRule(Builder b) {
        this.expression = b.expression;
        this.friendlyName = b.friendlyName;
        this.targets = b.targets;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    @JsonIgnore
    public List<WorkflowRuleTarget> getWorkflowRuleTargets() {
        return this.targets;
    }

    public static WorkflowRule fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(json, WorkflowRule.class);
    }

    public String toString() {
        return "WorkflowRule(expression=" + this.getExpression() + ", friendlyName=" + this.getFriendlyName() + ", targets=" + this.targets + ")";
    }

    public static class Builder {
        private String expression;
        private String friendlyName;
        private List<WorkflowRuleTarget> targets;

        public Builder(String expression, List<WorkflowRuleTarget> targets) {
            this.expression = expression;
            this.targets = targets;
        }

        public Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public WorkflowRule build() {
            return new WorkflowRule(this);
        }
    }
}

