/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Application;
import com.twilio.twiml.voice.Client;
import com.twilio.twiml.voice.Conference;
import com.twilio.twiml.voice.Number;
import com.twilio.twiml.voice.Queue;
import com.twilio.twiml.voice.Sim;
import com.twilio.twiml.voice.Sip;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Dial
extends TwiML {
    private final URI action;
    private final HttpMethod method;
    private final Integer timeout;
    private final Boolean hangupOnStar;
    private final Integer timeLimit;
    private final String callerId;
    private final Record record;
    private final Trim trim;
    private final URI recordingStatusCallback;
    private final HttpMethod recordingStatusCallbackMethod;
    private final List<RecordingEvent> recordingStatusCallbackEvent;
    private final Boolean answerOnBridge;
    private final RingTone ringTone;
    private final RecordingTrack recordingTrack;
    private final Boolean sequential;
    private final URI referUrl;
    private final HttpMethod referMethod;
    private final String number;

    private Dial() {
        this(new Builder());
    }

    private Dial(Builder b) {
        super("Dial", b);
        this.action = b.action;
        this.method = b.method;
        this.timeout = b.timeout;
        this.hangupOnStar = b.hangupOnStar;
        this.timeLimit = b.timeLimit;
        this.callerId = b.callerId;
        this.record = b.record;
        this.trim = b.trim;
        this.recordingStatusCallback = b.recordingStatusCallback;
        this.recordingStatusCallbackMethod = b.recordingStatusCallbackMethod;
        this.recordingStatusCallbackEvent = b.recordingStatusCallbackEvent;
        this.answerOnBridge = b.answerOnBridge;
        this.ringTone = b.ringTone;
        this.recordingTrack = b.recordingTrack;
        this.sequential = b.sequential;
        this.referUrl = b.referUrl;
        this.referMethod = b.referMethod;
        this.number = b.number;
    }

    @Override
    protected String getElementBody() {
        return this.getNumber() == null ? null : this.getNumber();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        if (this.isHangupOnStar() != null) {
            attrs.put("hangupOnStar", this.isHangupOnStar().toString());
        }
        if (this.getTimeLimit() != null) {
            attrs.put("timeLimit", this.getTimeLimit().toString());
        }
        if (this.getCallerId() != null) {
            attrs.put("callerId", this.getCallerId());
        }
        if (this.getRecord() != null) {
            attrs.put("record", this.getRecord().toString());
        }
        if (this.getTrim() != null) {
            attrs.put("trim", this.getTrim().toString());
        }
        if (this.getRecordingStatusCallback() != null) {
            attrs.put("recordingStatusCallback", this.getRecordingStatusCallback().toString());
        }
        if (this.getRecordingStatusCallbackMethod() != null) {
            attrs.put("recordingStatusCallbackMethod", this.getRecordingStatusCallbackMethod().toString());
        }
        if (this.getRecordingStatusCallbackEvents() != null) {
            attrs.put("recordingStatusCallbackEvent", this.getRecordingStatusCallbackEventsAsString());
        }
        if (this.isAnswerOnBridge() != null) {
            attrs.put("answerOnBridge", this.isAnswerOnBridge().toString());
        }
        if (this.getRingTone() != null) {
            attrs.put("ringTone", this.getRingTone().toString());
        }
        if (this.getRecordingTrack() != null) {
            attrs.put("recordingTrack", this.getRecordingTrack().toString());
        }
        if (this.isSequential() != null) {
            attrs.put("sequential", this.isSequential().toString());
        }
        if (this.getReferUrl() != null) {
            attrs.put("referUrl", this.getReferUrl().toString());
        }
        if (this.getReferMethod() != null) {
            attrs.put("referMethod", this.getReferMethod().toString());
        }
        return attrs;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Boolean isHangupOnStar() {
        return this.hangupOnStar;
    }

    public Integer getTimeLimit() {
        return this.timeLimit;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public Record getRecord() {
        return this.record;
    }

    public Trim getTrim() {
        return this.trim;
    }

    public URI getRecordingStatusCallback() {
        return this.recordingStatusCallback;
    }

    public HttpMethod getRecordingStatusCallbackMethod() {
        return this.recordingStatusCallbackMethod;
    }

    public List<RecordingEvent> getRecordingStatusCallbackEvents() {
        return this.recordingStatusCallbackEvent;
    }

    protected String getRecordingStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<RecordingEvent> iter = this.getRecordingStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public Boolean isAnswerOnBridge() {
        return this.answerOnBridge;
    }

    public RingTone getRingTone() {
        return this.ringTone;
    }

    public RecordingTrack getRecordingTrack() {
        return this.recordingTrack;
    }

    public Boolean isSequential() {
        return this.sequential;
    }

    public URI getReferUrl() {
        return this.referUrl;
    }

    public HttpMethod getReferMethod() {
        return this.referMethod;
    }

    public String getNumber() {
        return this.number;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI action;
        private HttpMethod method;
        private Integer timeout;
        private Boolean hangupOnStar;
        private Integer timeLimit;
        private String callerId;
        private Record record;
        private Trim trim;
        private URI recordingStatusCallback;
        private HttpMethod recordingStatusCallbackMethod;
        private List<RecordingEvent> recordingStatusCallbackEvent;
        private Boolean answerOnBridge;
        private RingTone ringTone;
        private RecordingTrack recordingTrack;
        private Boolean sequential;
        private URI referUrl;
        private HttpMethod referMethod;
        private String number;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Dial.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String number) {
            this.number = number;
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="timeout")
        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="hangupOnStar")
        public Builder hangupOnStar(Boolean hangupOnStar) {
            this.hangupOnStar = hangupOnStar;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="timeLimit")
        public Builder timeLimit(Integer timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="callerId")
        public Builder callerId(String callerId) {
            this.callerId = callerId;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="record")
        public Builder record(Record record) {
            this.record = record;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="trim")
        public Builder trim(Trim trim) {
            this.trim = trim;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallback")
        public Builder recordingStatusCallback(URI recordingStatusCallback) {
            this.recordingStatusCallback = recordingStatusCallback;
            return this;
        }

        public Builder recordingStatusCallback(String recordingStatusCallback) {
            this.recordingStatusCallback = Promoter.uriFromString(recordingStatusCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallbackMethod")
        public Builder recordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
            this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallbackEvent")
        public Builder recordingStatusCallbackEvents(List<RecordingEvent> recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
            return this;
        }

        public Builder recordingStatusCallbackEvents(RecordingEvent recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = Promoter.listOfOne(recordingStatusCallbackEvent);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="answerOnBridge")
        public Builder answerOnBridge(Boolean answerOnBridge) {
            this.answerOnBridge = answerOnBridge;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="ringTone")
        public Builder ringTone(RingTone ringTone) {
            this.ringTone = ringTone;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingTrack")
        public Builder recordingTrack(RecordingTrack recordingTrack) {
            this.recordingTrack = recordingTrack;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="sequential")
        public Builder sequential(Boolean sequential) {
            this.sequential = sequential;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="referUrl")
        public Builder referUrl(URI referUrl) {
            this.referUrl = referUrl;
            return this;
        }

        public Builder referUrl(String referUrl) {
            this.referUrl = Promoter.uriFromString(referUrl);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="referMethod")
        public Builder referMethod(HttpMethod referMethod) {
            this.referMethod = referMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="number")
        public Builder number(String number) {
            this.number = number;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Client")
        public Builder client(Client client) {
            this.children.add(client);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Conference")
        public Builder conference(Conference conference) {
            this.children.add(conference);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Number")
        public Builder number(Number number) {
            this.children.add(number);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Queue")
        public Builder queue(Queue queue) {
            this.children.add(queue);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Sim")
        public Builder sim(Sim sim) {
            this.children.add(sim);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Sip")
        public Builder sip(Sip sip) {
            this.children.add(sip);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Application")
        public Builder application(Application application) {
            this.children.add(application);
            return this;
        }

        public Dial build() {
            return new Dial(this);
        }
    }

    public static enum RecordingTrack {
        BOTH("both"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private final String value;

        private RecordingTrack(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum RingTone {
        AT("at"),
        AU("au"),
        BG("bg"),
        BR("br"),
        BE("be"),
        CH("ch"),
        CL("cl"),
        CN("cn"),
        CZ("cz"),
        DE("de"),
        DK("dk"),
        EE("ee"),
        ES("es"),
        FI("fi"),
        FR("fr"),
        GR("gr"),
        HU("hu"),
        IL("il"),
        IN("in"),
        IT("it"),
        LT("lt"),
        JP("jp"),
        MX("mx"),
        MY("my"),
        NL("nl"),
        NO("no"),
        NZ("nz"),
        PH("ph"),
        PL("pl"),
        PT("pt"),
        RU("ru"),
        SE("se"),
        SG("sg"),
        TH("th"),
        UK("uk"),
        US("us"),
        US_OLD("us-old"),
        TW("tw"),
        VE("ve"),
        ZA("za");

        private final String value;

        private RingTone(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum RecordingEvent {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        ABSENT("absent");

        private final String value;

        private RecordingEvent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Record {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_ANSWER("record-from-answer"),
        RECORD_FROM_RINGING("record-from-ringing"),
        RECORD_FROM_ANSWER_DUAL("record-from-answer-dual"),
        RECORD_FROM_RINGING_DUAL("record-from-ringing-dual");

        private final String value;

        private Record(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

