/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class SsmlBreak
extends TwiML {
    private final Strength strength;
    private final String time;

    private SsmlBreak() {
        this(new Builder());
    }

    private SsmlBreak(Builder b) {
        super("break", b);
        this.strength = b.strength;
        this.time = b.time;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getStrength() != null) {
            attrs.put("strength", this.getStrength().toString());
        }
        if (this.getTime() != null) {
            attrs.put("time", this.getTime());
        }
        return attrs;
    }

    public Strength getStrength() {
        return this.strength;
    }

    public String getTime() {
        return this.time;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private Strength strength;
        private String time;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a SsmlBreak.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="strength")
        public Builder strength(Strength strength) {
            this.strength = strength;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="time")
        public Builder time(String time) {
            this.time = time;
            return this;
        }

        public SsmlBreak build() {
            return new SsmlBreak(this);
        }
    }

    public static enum Strength {
        NONE("none"),
        X_WEAK("x-weak"),
        WEAK("weak"),
        MEDIUM("medium"),
        STRONG("strong"),
        X_STRONG("x-strong");

        private final String value;

        private Strength(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

