/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class SsmlSayAs
extends TwiML {
    private final InterpretAs interpretAs;
    private final Format format;
    private final String words;

    private SsmlSayAs() {
        this(new Builder(null));
    }

    private SsmlSayAs(Builder b) {
        super("say-as", b);
        this.interpretAs = b.interpretAs;
        this.format = b.format;
        this.words = b.words;
    }

    @Override
    protected String getElementBody() {
        return this.getWords() == null ? null : this.getWords();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getInterpretAs() != null) {
            attrs.put("interpret-as", this.getInterpretAs().toString());
        }
        if (this.getFormat() != null) {
            attrs.put("format", this.getFormat().toString());
        }
        return attrs;
    }

    public InterpretAs getInterpretAs() {
        return this.interpretAs;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getWords() {
        return this.words;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private InterpretAs interpretAs;
        private Format format;
        private String words;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a SsmlSayAs.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String words) {
            this.words = words;
        }

        private Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="interpret-as")
        public Builder interpretAs(InterpretAs interpretAs) {
            this.interpretAs = interpretAs;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="format")
        public Builder format(Format format) {
            this.format = format;
            return this;
        }

        public SsmlSayAs build() {
            return new SsmlSayAs(this);
        }
    }

    public static enum Format {
        MDY("mdy"),
        DMY("dmy"),
        YMD("ymd"),
        MD("md"),
        DM("dm"),
        YM("ym"),
        MY("my"),
        D("d"),
        M("m"),
        Y("y"),
        YYYYMMDD("yyyymmdd");

        private final String value;

        private Format(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum InterpretAs {
        CHARACTERS("characters"),
        SPELL_OUT("spell-out"),
        CARDINAL("cardinal"),
        NUMBER("number"),
        ORDINAL("ordinal"),
        DIGITS("digits"),
        FRACTION("fraction"),
        UNIT("unit"),
        DATE("date"),
        TIME("time"),
        ADDRESS("address"),
        EXPLETIVE("expletive"),
        TELEPHONE("telephone");

        private final String value;

        private InterpretAs(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

