/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Config;
import com.twilio.twiml.voice.Parameter;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Transcription
extends TwiML {
    private final String name;
    private final Track track;
    private final String statusCallbackUrl;
    private final StatusCallbackMethod statusCallbackMethod;
    private final String inboundTrackLabel;
    private final String outboundTrackLabel;
    private final Boolean partialResults;
    private final String languageCode;
    private final String transcriptionEngine;
    private final Boolean profanityFilter;
    private final String speechModel;
    private final String hints;
    private final Boolean enableAutomaticPunctuation;

    private Transcription() {
        this(new Builder());
    }

    private Transcription(Builder b) {
        super("Transcription", b);
        this.name = b.name;
        this.track = b.track;
        this.statusCallbackUrl = b.statusCallbackUrl;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.inboundTrackLabel = b.inboundTrackLabel;
        this.outboundTrackLabel = b.outboundTrackLabel;
        this.partialResults = b.partialResults;
        this.languageCode = b.languageCode;
        this.transcriptionEngine = b.transcriptionEngine;
        this.profanityFilter = b.profanityFilter;
        this.speechModel = b.speechModel;
        this.hints = b.hints;
        this.enableAutomaticPunctuation = b.enableAutomaticPunctuation;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getName() != null) {
            attrs.put("name", this.getName());
        }
        if (this.getTrack() != null) {
            attrs.put("track", this.getTrack().toString());
        }
        if (this.getStatusCallbackUrl() != null) {
            attrs.put("statusCallbackUrl", this.getStatusCallbackUrl());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getInboundTrackLabel() != null) {
            attrs.put("inboundTrackLabel", this.getInboundTrackLabel());
        }
        if (this.getOutboundTrackLabel() != null) {
            attrs.put("outboundTrackLabel", this.getOutboundTrackLabel());
        }
        if (this.isPartialResults() != null) {
            attrs.put("partialResults", this.isPartialResults().toString());
        }
        if (this.getLanguageCode() != null) {
            attrs.put("languageCode", this.getLanguageCode());
        }
        if (this.getTranscriptionEngine() != null) {
            attrs.put("transcriptionEngine", this.getTranscriptionEngine());
        }
        if (this.isProfanityFilter() != null) {
            attrs.put("profanityFilter", this.isProfanityFilter().toString());
        }
        if (this.getSpeechModel() != null) {
            attrs.put("speechModel", this.getSpeechModel());
        }
        if (this.getHints() != null) {
            attrs.put("hints", this.getHints());
        }
        if (this.isEnableAutomaticPunctuation() != null) {
            attrs.put("enableAutomaticPunctuation", this.isEnableAutomaticPunctuation().toString());
        }
        return attrs;
    }

    public String getName() {
        return this.name;
    }

    public Track getTrack() {
        return this.track;
    }

    public String getStatusCallbackUrl() {
        return this.statusCallbackUrl;
    }

    public StatusCallbackMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public String getInboundTrackLabel() {
        return this.inboundTrackLabel;
    }

    public String getOutboundTrackLabel() {
        return this.outboundTrackLabel;
    }

    public Boolean isPartialResults() {
        return this.partialResults;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getTranscriptionEngine() {
        return this.transcriptionEngine;
    }

    public Boolean isProfanityFilter() {
        return this.profanityFilter;
    }

    public String getSpeechModel() {
        return this.speechModel;
    }

    public String getHints() {
        return this.hints;
    }

    public Boolean isEnableAutomaticPunctuation() {
        return this.enableAutomaticPunctuation;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String name;
        private Track track;
        private String statusCallbackUrl;
        private StatusCallbackMethod statusCallbackMethod;
        private String inboundTrackLabel;
        private String outboundTrackLabel;
        private Boolean partialResults;
        private String languageCode;
        private String transcriptionEngine;
        private Boolean profanityFilter;
        private String speechModel;
        private String hints;
        private Boolean enableAutomaticPunctuation;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Transcription.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="track")
        public Builder track(Track track) {
            this.track = track;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackUrl")
        public Builder statusCallbackUrl(String statusCallbackUrl) {
            this.statusCallbackUrl = statusCallbackUrl;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackMethod")
        public Builder statusCallbackMethod(StatusCallbackMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="inboundTrackLabel")
        public Builder inboundTrackLabel(String inboundTrackLabel) {
            this.inboundTrackLabel = inboundTrackLabel;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="outboundTrackLabel")
        public Builder outboundTrackLabel(String outboundTrackLabel) {
            this.outboundTrackLabel = outboundTrackLabel;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="partialResults")
        public Builder partialResults(Boolean partialResults) {
            this.partialResults = partialResults;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="languageCode")
        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="transcriptionEngine")
        public Builder transcriptionEngine(String transcriptionEngine) {
            this.transcriptionEngine = transcriptionEngine;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="profanityFilter")
        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="speechModel")
        public Builder speechModel(String speechModel) {
            this.speechModel = speechModel;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="hints")
        public Builder hints(String hints) {
            this.hints = hints;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="enableAutomaticPunctuation")
        public Builder enableAutomaticPunctuation(Boolean enableAutomaticPunctuation) {
            this.enableAutomaticPunctuation = enableAutomaticPunctuation;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Config")
        public Builder config(Config config) {
            this.children.add(config);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Parameter")
        public Builder parameter(Parameter parameter) {
            this.children.add(parameter);
            return this;
        }

        public Transcription build() {
            return new Transcription(this);
        }
    }

    public static enum StatusCallbackMethod {
        GET("GET"),
        POST("POST");

        private final String value;

        private StatusCallbackMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Track {
        INBOUND_TRACK("inbound_track"),
        OUTBOUND_TRACK("outbound_track"),
        BOTH_TRACKS("both_tracks");

        private final String value;

        private Track(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

