/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.twitter.AbstractTwitterEndpoint;
import org.apache.camel.component.twitter.consumer.AbstractTwitterConsumerHandler;
import org.apache.camel.component.twitter.consumer.DefaultTwitterConsumer;
import twitter4j.v1.User;

public final class TwitterHelper {
    private TwitterHelper() {
    }

    public static void setUserHeader(Exchange exchange, User user) {
        TwitterHelper.setUserHeader(exchange.getIn(), user);
    }

    public static void setUserHeader(Message message, User user) {
        message.setHeader("CamelTwitterUser", user);
    }

    public static void setUserHeader(Exchange exchange, int index, User user, String role) {
        TwitterHelper.setUserHeader(exchange.getIn(), index, user, role);
    }

    public static void setUserHeader(Message message, int index, User user, String role) {
        message.setHeader("CamelTwitterUser" + index, user);
        message.setHeader("CamelTwitterUserRole" + index, role);
    }

    public static Consumer createConsumer(Processor processor, AbstractTwitterEndpoint endpoint, AbstractTwitterConsumerHandler handler) throws Exception {
        DefaultTwitterConsumer answer = new DefaultTwitterConsumer(endpoint, processor, handler);
        switch (endpoint.getEndpointType()) {
            case POLLING: {
                handler.setLastId(endpoint.getProperties().getSinceId());
                endpoint.configureConsumer(answer);
                break;
            }
            case DIRECT: {
                endpoint.configureConsumer(answer);
                break;
            }
        }
        return answer;
    }

    public static <T extends Enum<T>> T enumFromString(T[] values, String uri, T defaultValue) {
        for (int i = values.length - 1; i >= 0; --i) {
            if (!((Enum)values[i]).name().equalsIgnoreCase(uri)) continue;
            return values[i];
        }
        return defaultValue;
    }
}

