/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.directmessage;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.v1.User;

public class DirectMessageProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DirectMessageProducer.class);
    private TwitterEndpoint endpoint;
    private String user;

    public DirectMessageProducer(TwitterEndpoint endpoint, String user) {
        super(endpoint);
        this.endpoint = endpoint;
        this.user = user;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String toUsername = this.user;
        if (ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelTwitterUser", String.class))) {
            toUsername = exchange.getIn().getHeader("CamelTwitterUser", String.class);
        }
        String text = exchange.getIn().getBody(String.class);
        if (toUsername.isEmpty()) {
            throw new CamelExchangeException("Username not configured on TwitterEndpoint", exchange);
        }
        LOG.debug("Sending to: {} message: {}", (Object)toUsername, (Object)text);
        User userStatus = this.endpoint.getProperties().getTwitter().v1().users().showUser(toUsername);
        this.endpoint.getProperties().getTwitter().v1().directMessages().sendDirectMessage(userStatus.getId(), text);
    }
}

