/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.undertow.DefaultUndertowHttpBinding;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.http.base.HttpHelper;

public class RestUndertowHttpBinding
extends DefaultUndertowHttpBinding {
    public RestUndertowHttpBinding() {
    }

    public RestUndertowHttpBinding(boolean useStreaming) {
        super(useStreaming);
    }

    @Override
    public void populateCamelHeaders(HttpServerExchange httpExchange, Map<String, Object> headersMap, Exchange exchange) throws Exception {
        super.populateCamelHeaders(httpExchange, headersMap, exchange);
        String path = httpExchange.getRequestPath();
        if (path == null) {
            return;
        }
        UndertowEndpoint endpoint = (UndertowEndpoint)exchange.getFromEndpoint();
        String consumerPath = endpoint.getHttpURI().getPath();
        if (this.useRestMatching(consumerPath)) {
            HttpHelper.evalPlaceholders(headersMap, path, consumerPath);
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

