/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;

public class RequestCookieAttribute
implements ExchangeAttribute {
    private static final String TOKEN_PREFIX = "%{req-cookie,";
    private final String cookieName;

    public RequestCookieAttribute(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange2) {
        for (Cookie cookie : exchange2.requestCookies()) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange2, String newValue) throws ReadOnlyAttributeException {
        exchange2.setRequestCookie(new CookieImpl(this.cookieName, newValue));
    }

    public String toString() {
        return TOKEN_PREFIX + this.cookieName + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request cookie";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith(RequestCookieAttribute.TOKEN_PREFIX) && token.endsWith("}")) {
                String cookieName = token.substring(RequestCookieAttribute.TOKEN_PREFIX.length(), token.length() - 1);
                return new RequestCookieAttribute(cookieName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

