/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.PathMatcher;

public class ConfiguredPushHandler
implements HttpHandler {
    private final PathMatcher<String[]> pathMatcher = new PathMatcher();
    private final HttpHandler next;
    private final HeaderMap requestHeaders = new HeaderMap();

    public ConfiguredPushHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        PathMatcher.PathMatch<String[]> result;
        if (exchange2.getConnection().isPushSupported() && (result = this.pathMatcher.match(exchange2.getRelativePath())) != null) {
            String[] value = result.getValue();
            for (int i = 0; i < value.length; ++i) {
                exchange2.getConnection().pushResource(value[i], Methods.GET, this.requestHeaders);
            }
        }
        this.next.handleRequest(exchange2);
    }

    public ConfiguredPushHandler addRequestHeader(HttpString name, String value) {
        this.requestHeaders.put(name, value);
        return this;
    }

    public ConfiguredPushHandler addRoute(String url, String ... resourcesToPush) {
        if (url.endsWith("/*")) {
            String partial = url.substring(0, url.length() - 1);
            this.pathMatcher.addPrefixPath(partial, resourcesToPush);
        } else {
            this.pathMatcher.addExactPath(url, resourcesToPush);
        }
        return this;
    }
}

