/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.util.PathMatcher;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PathHandler
implements HttpHandler {
    private final PathMatcher<HttpHandler> pathMatcher = new PathMatcher();
    private final LRUCache<String, PathMatcher.PathMatch<HttpHandler>> cache;

    public PathHandler(HttpHandler defaultHandler) {
        this(0);
        this.pathMatcher.addPrefixPath("/", defaultHandler);
    }

    public PathHandler(HttpHandler defaultHandler, int cacheSize) {
        this(cacheSize);
        this.pathMatcher.addPrefixPath("/", defaultHandler);
    }

    public PathHandler() {
        this(0);
    }

    public PathHandler(int cacheSize) {
        this.cache = cacheSize > 0 ? new LRUCache(cacheSize, -1, true) : null;
    }

    public String toString() {
        Set<Map.Entry<String, HttpHandler>> paths = this.pathMatcher.getPaths().entrySet();
        if (paths.size() == 1) {
            return "path( " + paths.toArray()[0] + " )";
        }
        return "path( {" + paths.stream().map(s -> ((HttpHandler)s.getValue()).toString()).collect(Collectors.joining(", ")) + "} )";
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        PathMatcher.PathMatch<HttpHandler> match = null;
        boolean hit = false;
        if (this.cache != null) {
            match = this.cache.get(exchange2.getRelativePath());
            hit = true;
        }
        if (match == null) {
            match = this.pathMatcher.match(exchange2.getRelativePath());
        }
        if (match.getValue() == null) {
            ResponseCodeHandler.HANDLE_404.handleRequest(exchange2);
            return;
        }
        if (hit) {
            this.cache.add(exchange2.getRelativePath(), match);
        }
        exchange2.setRelativePath(match.getRemaining());
        if (exchange2.getResolvedPath().isEmpty()) {
            exchange2.setResolvedPath(match.getMatched());
        } else {
            exchange2.setResolvedPath(exchange2.getResolvedPath() + match.getMatched());
        }
        match.getValue().handleRequest(exchange2);
    }

    @Deprecated(since="1.0.0", forRemoval=true)
    public synchronized PathHandler addPath(String path, HttpHandler handler) {
        return this.addPrefixPath(path, handler);
    }

    public synchronized PathHandler addPrefixPath(String path, HttpHandler handler) {
        Handlers.handlerNotNull(handler);
        this.pathMatcher.addPrefixPath(path, handler);
        return this;
    }

    public synchronized PathHandler addExactPath(String path, HttpHandler handler) {
        Handlers.handlerNotNull(handler);
        this.pathMatcher.addExactPath(path, handler);
        return this;
    }

    @Deprecated
    public synchronized PathHandler removePath(String path) {
        return this.removePrefixPath(path);
    }

    public synchronized PathHandler removePrefixPath(String path) {
        this.pathMatcher.removePrefixPath(path);
        return this;
    }

    public synchronized PathHandler removeExactPath(String path) {
        this.pathMatcher.removeExactPath(path);
        return this;
    }

    public synchronized PathHandler clearPaths() {
        this.pathMatcher.clearPaths();
        return this;
    }
}

