/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.AttachmentKey;
import io.undertow.util.PathTemplate;
import io.undertow.util.PathTemplateMatcher;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PathTemplateHandler
implements HttpHandler {
    private final boolean rewriteQueryParameters;
    private final HttpHandler next;
    @Deprecated
    public static final AttachmentKey<PathTemplateMatch> PATH_TEMPLATE_MATCH = AttachmentKey.create(PathTemplateMatch.class);
    private final PathTemplateMatcher<HttpHandler> pathTemplateMatcher = new PathTemplateMatcher();

    public PathTemplateHandler() {
        this(true);
    }

    public PathTemplateHandler(boolean rewriteQueryParameters) {
        this(ResponseCodeHandler.HANDLE_404, rewriteQueryParameters);
    }

    public PathTemplateHandler(HttpHandler next) {
        this(next, true);
    }

    public PathTemplateHandler(HttpHandler next, boolean rewriteQueryParameters) {
        this.rewriteQueryParameters = rewriteQueryParameters;
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange2) throws Exception {
        PathTemplateMatcher.PathMatchResult<HttpHandler> match = this.pathTemplateMatcher.match(exchange2.getRelativePath());
        if (match == null) {
            this.next.handleRequest(exchange2);
            return;
        }
        exchange2.putAttachment(PATH_TEMPLATE_MATCH, new PathTemplateMatch(match.getMatchedTemplate(), match.getParameters()));
        exchange2.putAttachment(io.undertow.util.PathTemplateMatch.ATTACHMENT_KEY, new io.undertow.util.PathTemplateMatch(match.getMatchedTemplate(), match.getParameters()));
        if (this.rewriteQueryParameters) {
            for (Map.Entry<String, String> entry : match.getParameters().entrySet()) {
                exchange2.addQueryParam(entry.getKey(), entry.getValue());
            }
        }
        match.getValue().handleRequest(exchange2);
    }

    public PathTemplateHandler add(String uriTemplate, HttpHandler handler) {
        this.pathTemplateMatcher.add(uriTemplate, handler);
        return this;
    }

    public PathTemplateHandler remove(String uriTemplate) {
        this.pathTemplateMatcher.remove(uriTemplate);
        return this;
    }

    public String toString() {
        Set<PathTemplate> paths = this.pathTemplateMatcher.getPathTemplates();
        if (paths.size() == 1) {
            return "path-template( " + paths.toArray()[0] + " )";
        }
        return "path-template( {" + paths.stream().map(s -> s.getTemplateString().toString()).collect(Collectors.joining(", ")) + "} )";
    }

    @Deprecated
    public static final class PathTemplateMatch {
        private final String matchedTemplate;
        private final Map<String, String> parameters;

        public PathTemplateMatch(String matchedTemplate, Map<String, String> parameters) {
            this.matchedTemplate = matchedTemplate;
            this.parameters = parameters;
        }

        public String getMatchedTemplate() {
            return this.matchedTemplate;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

