/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.conduits.HeadStreamSinkConduit;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2DataStreamSinkChannel;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http.HttpContinue;
import io.undertow.server.protocol.http.HttpRequestParser;
import io.undertow.server.protocol.http2.Http2ServerConnection;
import io.undertow.server.protocol.http2.Http2SslSessionInfo;
import io.undertow.util.BadRequestException;
import io.undertow.util.ConduitFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.ImmediatePooledByteBuffer;
import io.undertow.util.Methods;
import io.undertow.util.ParameterLimitException;
import io.undertow.util.Protocols;
import io.undertow.util.URLUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.channels.Channels;
import org.xnio.conduits.StreamSinkConduit;

public class Http2ReceiveListener
implements ChannelListener<Http2Channel> {
    private final HttpHandler rootHandler;
    private final long maxEntitySize;
    private final OptionMap undertowOptions;
    private final String encoding;
    private final boolean decode;
    private final StringBuilder decodeBuffer = new StringBuilder();
    private final boolean slashDecodingFlag;
    private final int bufferSize;
    private final int maxParameters;
    private final boolean recordRequestStartTime;
    private final boolean allowUnescapedCharactersInUrl;
    private final ConnectorStatisticsImpl connectorStatistics;

    public Http2ReceiveListener(HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize, ConnectorStatisticsImpl connectorStatistics) {
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.connectorStatistics = connectorStatistics;
        this.maxEntitySize = undertowOptions.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.slashDecodingFlag = URLUtils.getSlashDecodingFlag(undertowOptions);
        this.decode = undertowOptions.get(UndertowOptions.DECODE_URL, true);
        this.maxParameters = undertowOptions.get(UndertowOptions.MAX_PARAMETERS, 1000);
        this.recordRequestStartTime = undertowOptions.get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
        this.encoding = undertowOptions.get(UndertowOptions.DECODE_URL, true) ? undertowOptions.get(UndertowOptions.URL_CHARSET, StandardCharsets.UTF_8.name()) : null;
        this.allowUnescapedCharactersInUrl = undertowOptions.get(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, false);
    }

    @Override
    public void handleEvent(Http2Channel channel) {
        try {
            AbstractHttp2StreamSourceChannel frame = (AbstractHttp2StreamSourceChannel)channel.receive();
            if (frame == null) {
                return;
            }
            if (frame instanceof Http2StreamSourceChannel) {
                this.handleRequests(channel, (Http2StreamSourceChannel)frame);
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)channel);
        }
        catch (Throwable t) {
            UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
            IoUtils.safeClose((Closeable)channel);
        }
    }

    private void handleRequests(Http2Channel channel, Http2StreamSourceChannel frame) {
        Http2StreamSourceChannel dataChannel = frame;
        Http2ServerConnection connection = new Http2ServerConnection(channel, dataChannel, this.undertowOptions, this.bufferSize, this.rootHandler);
        if (!this.checkRequestHeaders(dataChannel.getHeaders())) {
            channel.sendRstStream(frame.getStreamId(), 1);
            try {
                Channels.drain(frame, Long.MAX_VALUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        final HttpServerExchange exchange2 = new HttpServerExchange(connection, dataChannel.getHeaders(), dataChannel.getResponseChannel().getHeaders(), this.maxEntitySize);
        dataChannel.setTrailersHandler(new Http2StreamSourceChannel.TrailersHandler(){

            @Override
            public void handleTrailers(HeaderMap headerMap) {
                exchange2.putAttachment(HttpAttachments.REQUEST_TRAILERS, headerMap);
            }
        });
        connection.setExchange(exchange2);
        dataChannel.setMaxStreamSize(this.maxEntitySize);
        exchange2.setRequestScheme(exchange2.getRequestHeaders().getFirst(Http2Channel.SCHEME));
        exchange2.setRequestMethod(Methods.fromString(exchange2.getRequestHeaders().getFirst(Http2Channel.METHOD)));
        exchange2.getRequestHeaders().put(Headers.HOST, exchange2.getRequestHeaders().getFirst(Http2Channel.AUTHORITY));
        if (!Connectors.areRequestHeadersValid(exchange2.getRequestHeaders())) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf("Invalid headers in HTTP/2 request, closing connection. Remote peer %s", (Object)connection.getPeerAddress());
            channel.sendGoAway(1);
            return;
        }
        String path = exchange2.getRequestHeaders().getFirst(Http2Channel.PATH);
        if (path == null || path.isEmpty()) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf("No :path header sent in HTTP/2 request, closing connection. Remote peer %s", (Object)connection.getPeerAddress());
            channel.sendGoAway(1);
            return;
        }
        if (this.recordRequestStartTime) {
            Connectors.setRequestStartTime(exchange2);
        }
        this.handleCommonSetup(dataChannel.getResponseChannel(), exchange2, connection);
        if (!dataChannel.isOpen()) {
            Connectors.terminateRequest(exchange2);
        } else {
            dataChannel.setCompletionListener(new ChannelListener<Http2StreamSourceChannel>(){

                @Override
                public void handleEvent(Http2StreamSourceChannel channel) {
                    Connectors.terminateRequest(exchange2);
                }
            });
        }
        if (this.connectorStatistics != null) {
            this.connectorStatistics.setup(exchange2);
        }
        try {
            Connectors.setExchangeRequestPath(exchange2, path, this.encoding, this.decode, this.slashDecodingFlag, this.decodeBuffer, this.maxParameters);
        }
        catch (BadRequestException | ParameterLimitException e) {
            UndertowLogger.REQUEST_IO_LOGGER.debug("Failed to set request path", e);
            exchange2.setStatusCode(400);
            exchange2.endExchange();
            return;
        }
        exchange2.getRequestHeaders().remove(Http2Channel.AUTHORITY);
        exchange2.getRequestHeaders().remove(Http2Channel.PATH);
        exchange2.getRequestHeaders().remove(Http2Channel.SCHEME);
        exchange2.getRequestHeaders().remove(Http2Channel.METHOD);
        Connectors.executeRootHandler(this.rootHandler, exchange2);
    }

    void handleInitialRequest(HttpServerExchange initial, Http2Channel channel, byte[] data) {
        this.handleInitialRequest(initial, channel, data, this.decode, this.decode);
    }

    void handleInitialRequest(HttpServerExchange initial, Http2Channel channel, byte[] data, boolean decode, boolean decodeQueryString) {
        Http2HeadersStreamSinkChannel sink = channel.createInitialUpgradeResponseStream();
        Http2ServerConnection connection = new Http2ServerConnection(channel, sink, this.undertowOptions, this.bufferSize, this.rootHandler);
        HeaderMap requestHeaders = new HeaderMap();
        for (HeaderValues hv : initial.getRequestHeaders()) {
            requestHeaders.putAll(hv.getHeaderName(), hv);
        }
        HttpServerExchange exchange2 = new HttpServerExchange(connection, requestHeaders, sink.getHeaders(), this.maxEntitySize);
        if (initial.getRequestHeaders().contains(Headers.EXPECT)) {
            HttpContinue.markContinueResponseSent(exchange2);
        }
        if (initial.getAttachment(HttpAttachments.REQUEST_TRAILERS) != null) {
            exchange2.putAttachment(HttpAttachments.REQUEST_TRAILERS, initial.getAttachment(HttpAttachments.REQUEST_TRAILERS));
        }
        Connectors.setRequestStartTime(initial, exchange2);
        connection.setExchange(exchange2);
        exchange2.setRequestScheme(initial.getRequestScheme());
        exchange2.setRequestMethod(initial.getRequestMethod());
        exchange2.setQueryString(initial.getQueryString());
        if (data != null) {
            Connectors.ungetRequestBytes(exchange2, new ImmediatePooledByteBuffer(ByteBuffer.wrap(data)));
        }
        Connectors.terminateRequest(exchange2);
        String uri = exchange2.getQueryString().isEmpty() ? initial.getRequestURI() : initial.getRequestURI() + "?" + exchange2.getQueryString();
        try {
            Connectors.setExchangeRequestPath(exchange2, uri, this.encoding, decode, decodeQueryString, this.slashDecodingFlag, this.decodeBuffer, this.maxParameters);
        }
        catch (BadRequestException | ParameterLimitException e) {
            exchange2.setStatusCode(400);
            exchange2.endExchange();
            return;
        }
        this.handleCommonSetup(sink, exchange2, connection);
        Connectors.executeRootHandler(this.rootHandler, exchange2);
    }

    private void handleCommonSetup(Http2HeadersStreamSinkChannel sink, final HttpServerExchange exchange2, Http2ServerConnection connection) {
        Http2Channel channel = (Http2Channel)sink.getChannel();
        SSLSession session = channel.getSslSession();
        if (session != null) {
            connection.setSslSessionInfo(new Http2SslSessionInfo(channel));
        }
        sink.setTrailersProducer(new Http2DataStreamSinkChannel.TrailersProducer(){

            @Override
            public HeaderMap getTrailers() {
                Supplier<HeaderMap> supplier = exchange2.getAttachment(HttpAttachments.RESPONSE_TRAILER_SUPPLIER);
                if (supplier != null) {
                    return supplier.get();
                }
                return exchange2.getAttachment(HttpAttachments.RESPONSE_TRAILERS);
            }
        });
        sink.setCompletionListener(new ChannelListener<Http2DataStreamSinkChannel>(){

            @Override
            public void handleEvent(Http2DataStreamSinkChannel channel) {
                Connectors.terminateResponse(exchange2);
            }
        });
        exchange2.setProtocol(Protocols.HTTP_2_0);
        if (exchange2.getRequestMethod().equals(Methods.HEAD)) {
            exchange2.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

                @Override
                public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange2) {
                    return new HeadStreamSinkConduit(factory.create(), null, true);
                }
            });
        }
    }

    private boolean checkRequestHeaders(HeaderMap headers) {
        if (headers.count(Http2Channel.METHOD) != 1 || headers.contains(Headers.CONNECTION)) {
            return false;
        }
        if (headers.get(Http2Channel.METHOD).contains("CONNECT") ? headers.contains(Http2Channel.SCHEME) || headers.contains(Http2Channel.PATH) || headers.count(Http2Channel.AUTHORITY) != 1 : headers.count(Http2Channel.SCHEME) != 1 || headers.count(Http2Channel.PATH) != 1) {
            return false;
        }
        if (headers.contains(Headers.TE)) {
            for (String value : headers.get(Headers.TE)) {
                if (value.equals("trailers")) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.PATH) && !this.allowUnescapedCharactersInUrl) {
            for (Object b : (Object)headers.get(Http2Channel.PATH).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (HttpRequestParser.isTargetCharacterAllowed((char)b)) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.SCHEME)) {
            for (Object b : (Object)headers.get(Http2Channel.SCHEME).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (Connectors.isValidSchemeCharacter((byte)b)) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.AUTHORITY)) {
            for (Object b : (Object)headers.get(Http2Channel.AUTHORITY).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (HttpRequestParser.isTargetCharacterAllowed((char)b)) continue;
                return false;
            }
        }
        if (headers.contains(Http2Channel.METHOD)) {
            for (Object b : (Object)headers.get(Http2Channel.METHOD).getFirst().getBytes(StandardCharsets.ISO_8859_1)) {
                if (Connectors.isValidTokenCharacter((byte)b)) continue;
                return false;
            }
        }
        return true;
    }
}

