/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ServletInfo;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.util.List;

class LifecyleInterceptorInvocation
implements LifecycleInterceptor.LifecycleContext {
    private final List<LifecycleInterceptor> list;
    private final ServletInfo servletInfo;
    private final FilterInfo filterInfo;
    private final Servlet servlet;
    private final Filter filter;
    private int i;
    private final ServletConfig servletConfig;
    private final FilterConfig filterConfig;

    LifecyleInterceptorInvocation(List<LifecycleInterceptor> list, ServletInfo servletInfo, Servlet servlet, ServletConfig servletConfig) {
        this.list = list;
        this.servletInfo = servletInfo;
        this.servlet = servlet;
        this.servletConfig = servletConfig;
        this.filter = null;
        this.filterConfig = null;
        this.filterInfo = null;
        this.i = list.size();
    }

    LifecyleInterceptorInvocation(List<LifecycleInterceptor> list, ServletInfo servletInfo, Servlet servlet) {
        this.list = list;
        this.servlet = servlet;
        this.servletInfo = servletInfo;
        this.filterInfo = null;
        this.servletConfig = null;
        this.filter = null;
        this.filterConfig = null;
        this.i = list.size();
    }

    LifecyleInterceptorInvocation(List<LifecycleInterceptor> list, FilterInfo filterInfo, Filter filter2, FilterConfig filterConfig) {
        this.list = list;
        this.servlet = null;
        this.servletConfig = null;
        this.filter = filter2;
        this.filterConfig = filterConfig;
        this.filterInfo = filterInfo;
        this.servletInfo = null;
        this.i = list.size();
    }

    LifecyleInterceptorInvocation(List<LifecycleInterceptor> list, FilterInfo filterInfo, Filter filter2) {
        this.list = list;
        this.servlet = null;
        this.servletConfig = null;
        this.filter = filter2;
        this.filterConfig = null;
        this.filterInfo = filterInfo;
        this.servletInfo = null;
        this.i = list.size();
    }

    @Override
    public void proceed() throws ServletException {
        if (--this.i >= 0) {
            LifecycleInterceptor next = this.list.get(this.i);
            if (this.filter != null) {
                if (this.filterConfig == null) {
                    next.destroy(this.filterInfo, this.filter, (LifecycleInterceptor.LifecycleContext)this);
                } else {
                    next.init(this.filterInfo, this.filter, (LifecycleInterceptor.LifecycleContext)this);
                }
            } else if (this.servletConfig == null) {
                next.destroy(this.servletInfo, this.servlet, (LifecycleInterceptor.LifecycleContext)this);
            } else {
                next.init(this.servletInfo, this.servlet, (LifecycleInterceptor.LifecycleContext)this);
            }
        } else if (this.i == -1) {
            if (this.filter != null) {
                if (this.filterConfig == null) {
                    this.filter.destroy();
                } else {
                    this.filter.init(this.filterConfig);
                }
            } else if (this.servletConfig == null) {
                this.servlet.destroy();
            } else {
                this.servlet.init(this.servletConfig);
            }
        }
    }
}

